<?= $this-> include('templates/header');?>
<?php 
use App\Libraries\TimeHelper; 
use App\Libraries\NumberFormatter;

?>
<main id="nsofts_main">
    <div class="nsofts-container">

        <div class="row g-4">
            
            <div class="col-xl-3 col-sm-6 col-12">
                <div class="card card-badge">
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <span class="h6 font-semibold text-muted text-sm d-block mb-2">Categories</span>
                                <span class="h3 font-bold mb-0"><?= esc(NumberFormatter::format($categoryTotalCount)); ?></span>
                            </div>
                            <div class="col-auto">
                                <div class="icon-shape bg-warning text-white text-lg">
                                    <i class="ri-folder-3-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6 col-12">
                <div class="card card-badge">
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <span class="h6 font-semibold text-muted text-sm d-block mb-2">Countries</span>
                                <span class="h3 font-bold mb-0"><?= esc(NumberFormatter::format($countriesTotalCount)); ?></span>
                            </div>
                            <div class="col-auto">
                                <div class="icon-shape bg-danger text-white text-lg">
                                    <i class="ri-global-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6 col-12">
                <div class="card card-badge">
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <span class="h6 font-semibold text-muted text-sm d-block mb-2">Radio</span>
                                <span class="h3 font-bold mb-0"><?= esc(NumberFormatter::format($radioTotalCount)); ?></span>
                            </div>
                            <div class="col-auto">
                                <div class="icon-shape bg-success text-white text-lg">
                                    <i class="ri-radio-2-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6 col-12">
                <div class="card card-badge">
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <span class="h6 font-semibold text-muted text-sm d-block mb-2">Podcast</span>
                                <span class="h3 font-bold mb-0"><?= esc(NumberFormatter::format($podcastTotalCount)); ?></span>
                            </div>
                            <div class="col-auto">
                                <div class="icon-shape bg-info text-white text-lg">
                                    <i class="ri-disc-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6 col-12">
                <div class="card card-badge">
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <span class="h6 font-semibold text-muted text-sm d-block mb-2">Episode</span>
                                <span class="h3 font-bold mb-0"><?= esc(NumberFormatter::format($episodeTotalCount)); ?></span>
                            </div>
                            <div class="col-auto">
                                <div class="icon-shape bg-primary text-white text-lg">
                                    <i class="ri-music-2-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6 col-12">
                <div class="card card-badge">
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <span class="h6 font-semibold text-muted text-sm d-block mb-2">Reports</span>
                                <span class="h3 font-bold mb-0"><?= esc(NumberFormatter::format($reportsTotalCount)); ?></span>
                            </div>
                            <div class="col-auto">
                                <div class="icon-shape bg-warning text-white text-lg">
                                    <i class="ri-feedback-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6 col-12">
                <div class="card card-badge">
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <span class="h6 font-semibold text-muted text-sm d-block mb-2">Users</span>
                                <span class="h3 font-bold mb-0"><?= esc(NumberFormatter::format($usersTotalCount)); ?></span>
                            </div>
                            <div class="col-auto">
                                <div class="icon-shape bg-danger text-white text-lg">
                                    <i class="ri-folder-user-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6 col-12">
                <div class="card card-badge">
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <span class="h6 font-semibold text-muted text-sm d-block mb-2">Admin Users</span>
                                <span class="h3 font-bold mb-0"><?= esc(NumberFormatter::format($adminTotalCount)); ?></span>
                            </div>
                            <div class="col-auto">
                                <div class="icon-shape bg-success text-white text-lg">
                                    <i class="ri-admin-line"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
            
        <div class="row g-4 mt-2">
            
            <div class="col-lg-7 col-md-6">
                <div class="card card-dashboard h-100">
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="me-2">
                                <h5 class="mb-4">Users Analytics</h5>
                            </div>
                            <div class="d-inline-flex">
                                <form method="get" id="graphFilter">
                                <select class="form-control" name="filterByYear" style="width: 120px;" >
                                <?php 
                                    $currentYear=date('Y');
                                    $minYear=2023;
                                    for ($i=$currentYear; $i >= $minYear ; $i--) { 
                                ?>
                                <option value="<?=$i?>" <?=(isset($_GET['filterByYear']) && $_GET['filterByYear']==$i) ? 'selected' : ''?>><?=$i?></option>
                                <?php } ?>
                                </select>
                            </form>
                            </div>
                        </div>
                        <div style="height: 300px">
                            <?php if($no_data_status){ ?>
                                <h3 class="text-muted text-center" style="padding-bottom: 2em">No data found !</h3>
                            <?php } else{ ?>
                                <canvas id="nsofts_analytics"></canvas>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>   
            
            <div class="col-lg-5 col-md-6">
                <div class="card card-dashboard h-100">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center justify-content-between">
                            <h5 class="mb-0">New Reports</h5>
                        </div>
                        <?php if(!empty($result)){ ?>
                        
                            <?php $i=0; foreach($result as $row){ ?>
                            
                                <div class="d-flex align-items-center mt-4">
                                    <span class="d-block fw-semibold"><?php echo $row['report_title'];?></span>
                                    <span><td><?= esc(TimeHelper::calculateTimeSpan($row['report_on'])); ?></td></span>
                                </div>
                                
                            <?php $i++; } ?> 
                            
                        <?php } else { ?>
                            <ul class="p-2">
                                <h3 class="text-center">No data found !</h3>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
            </div> 
        </div>
        
    </div>
</main>
<?= $this-> include('templates/footer');?>

<?php if(!$no_data_status){ ?>
    <script>
        const isDarkMode = function() {
            return localStorage.getItem('dark_mode') === 'true';
        }
        
        const getCSSVarValue = function(name) {
            let hex = getComputedStyle(document.documentElement).getPropertyValue('--ns-' + name);
            if (hex && hex.length > 0) {
                hex = hex.trim();
            }
            return hex;
        }
        
        if (Chart) {
            const defaults = Chart.defaults;
            const config = {
                color: isDarkMode() ? '#fff' : getCSSVarValue('body-color'),
                borderColor: isDarkMode() ? '#2d2f32' : getCSSVarValue('gray-10'),
                
                // Chart typo
                font: {
                    family: getCSSVarValue('body-font-family'),
                    size: 13
                },
            };
            
            Object.assign(defaults, config);
        }
        
        const canvas = document.getElementById('nsofts_analytics');
        if (canvas) {
            const config = {
                type: 'line',
                data: {
                    
                    labels: <?php echo "[".$monthStr."]";?>,
                    datasets: [
                        {
                            label: 'Users',
                            data: <?php echo "[".$countStr."]";?>,
                            backgroundColor: getCSSVarValue('primary'),
                            borderColor: getCSSVarValue('primary'),
                            tension: 0.1
                        }
                    ]
                },
                options: {
                    title: {
                        display: false,
                    },
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            min: 0,
                            
                            grid: {
                                borderColor: isDarkMode() ? '#2d2f32' : getCSSVarValue('gray-10'),
                            }
                        },
                        x: {
                            grid: {
                                borderColor: isDarkMode() ? '#2d2f32' : getCSSVarValue('gray-10'),
                            }
                        }
                    },
                    layout: {
                        margin: 0,
                        padding: 0
                    },
                    plugins: {
                        legend: {
                            display: false
                        },
                    }
                }
            };
            analyticsChart = new Chart(canvas, config);
        }
    </script>
<?php } ?>
<script>
  document.querySelector("select[name='filterByYear']").addEventListener("change", function() {
    document.getElementById("graphFilter").submit();
  });
</script>